function CDX = import_DTD(CDX, data_bloomberg)
% --------------------------------------------------------------------------------------------------
% Import DTD data and impute into CDX structure.
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% data_bloomberg    ... structure with daily stock prices and market cap
% --------------------------------------------------------------------------------------------------
% sample call: import_DTD(CDX_NA_IG2, data_bloomberg)
% --------------------------------------------------------------------------------------------------

% Determine available files
files = dir('c:/thesis/mba slides/leandro code/mats/dtd');
files = {files(3:end).name};
num_firms = length(files);
company_names = {CDX.portfolio.ticker};
bloomberg_tickers = {data_bloomberg.ticker};

% % Replace ticker 'FD' with 'M'
% macys_pos = find(strcmp(bloomberg_tickers, 'FD'));
% covariate_tickers{macys_pos} = 'M';

% Tidy up fields in cds portfolio
for i=1:length(company_names)
    cds = CDX.portfolio(i);
    cds.DTD = [];
    cds.assets = [];
    
    % Impute stock price and market cap data from Bloomberg
    pos = find(strcmp(bloomberg_tickers, cds.ticker));
    if (~isempty(pos))
        data = data_bloomberg(pos);
        matching_pos = fuzzy_datenum_match(cds.dates{1}, data.dates);
        cds.share_price = data.price(matching_pos);
        cds.mcap = data.mcap(matching_pos);
    else
        cds.share_price = [];
    end
    
    if (i == 1)
        cds_portfolio = cds;
    else
        cds_portfolio(i) = cds;
    end
end
CDX.portfolio = cds_portfolio;

% Generate table for GFKEY - TICKER matching
[num, txt] = xlsread('c:/thesis/data/compustat/stocks cdx.xls', 1);
tickers = txt(2:end,end-1);
gvkeys = num(:,1);
new_pos = find(diff([0; gvkeys]) ~= 0);
tickers = tickers(new_pos);
gvkeys = gvkeys(new_pos);

for i=1:num_firms
    % Map gvkey to ticker symbol
    pos = findstr(files{i}, '_');
    pos2 = findstr(files{i}, '.mat');
    gvkey = str2double(files{i}((pos+1):(pos2-1)));
    pos = find(gvkeys == gvkey);
    if (isempty(pos))
        continue;
    end
    ticker = tickers{pos};

    % Import Leandro's data
    filename = ['c:/thesis/mba slides/leandro code/mats/dtd/' files{i}];
    load(filename);

    % Determine matching stock price data
    pos = find(strcmp(company_names, ticker));
    if (isempty(pos))
        continue;
    end
    cds = CDX.portfolio(pos);
    
    % Impute DTD data
    DTD_dates = data(:,1);
    matching_pos = fuzzy_datenum_match(cds.dates{1}, DTD_dates);
    cds.assets = data(matching_pos, 2);
    %cds.mcap = data(matching_pos, 3);
    cds.debt = data(matching_pos, 4);
    DTD = data(matching_pos, 5);
    if (sum(isnan(DTD)) >0)
        test=1;
    end
    cds.DTD = DTD;
    CDX.portfolio(pos) = cds; 
end


